unit Fngmain;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, agsocket, agfinger, Buttons, StdCtrls, ExtCtrls;

type
  TFingerForm = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Memo1: TMemo;
    Label1: TLabel;
    QueryEdit: TEdit;
    FingerButton: TSpeedButton;
    CancelButton: TSpeedButton;
    agFinger1: TagFinger;
    procedure agFinger1Cancel(Sender: TObject);
    procedure agFinger1Closed(Sender: TObject);
    procedure agFinger1Error(Sender: TObject; var Msg: OpenString);
    procedure agFinger1Open(Sender: TObject);
    procedure FingerButtonClick(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
    procedure agFinger1SendingQuery(Sender: TObject);
    procedure agFinger1Progress(Sender: TObject; Perc: Integer;
      Transferred: Longint);
  private
    { Private declarations }
    procedure EnableControls;
    procedure DisableControls;
  public
    { Public declarations }
  end;

var
  FingerForm: TFingerForm;

implementation

{$R *.DFM}

procedure TFingerForm.agFinger1Cancel(Sender: TObject);
begin
  Panel2.Caption:='Operation has been canceled';
end;

procedure TFingerForm.agFinger1Closed(Sender: TObject);
begin
  Panel2.Caption:='Connection closed';
end;

procedure TFingerForm.agFinger1Error(Sender: TObject; var Msg: OpenString);
begin
  Panel2.Caption:=Msg;
end;

procedure TFingerForm.agFinger1Open(Sender: TObject);
begin
  Panel2.Caption:='Opening connection';
end;

procedure TFingerForm.EnableControls;
begin
  FingerButton.Enabled:=true;
  CancelButton.Enabled:=false;
  QueryEdit.Enabled:=true;
end;

procedure TFingerForm.DisableControls;
begin
  FingerButton.Enabled:=false;
  CancelButton.Enabled:=true;
  QueryEdit.Enabled:=false;
end;

procedure TFingerForm.FingerButtonClick(Sender: TObject);
begin
  agFinger1.Query:=QueryEdit.Text;
  Memo1.Clear;
  DisableControls;
  try
    agFinger1.Execute;
    Memo1.Lines.LoadFromStream(agFinger1.InStream);
  finally
    EnableControls;
  end;
end;

procedure TFingerForm.CancelButtonClick(Sender: TObject);
begin
  agFinger1.Cancel;
end;

procedure TFingerForm.agFinger1SendingQuery(Sender: TObject);
begin
  Panel2.Caption:='Sending query';
end;

procedure TFingerForm.agFinger1Progress(Sender: TObject; Perc: Integer;
  Transferred: Longint);
begin
  Panel2.Caption:=IntToStr(Transferred)+' bytes received';
end;

end.
